<?php
class SiteInfo implements \JsonSerializable{

    private $site;
    private $password;
    private $webserviceAddress;
    private $opticianName;
    private $opticianAddress;
    private $opticianPhone;
    private $opticianLogo;
    private $showAppointmentTypes;
    private $rawData;
    private $singleOpticianView;
    private $singleOpticianName;

    public function __construct()
    {
        
    }

    public function setAllFromStr($wsdl_response_str){
        //Sample string: 854088_OpenGate7_http://87.127.13.154:896/DiaryWebService.svc?wsdl_Joe Boggs Opticians_1 Portola Drive, Rockford Hills, Los Santos_328-555-0108_https://cdn.grandvision.io/binaries/_ht_1618414401730/content/gallery/gb-visionexpress/logos/logo-1.png
        $info = explode("|", $wsdl_response_str);
        // Set values to member variables
        $this->site = $info[0];
        $this->password = $info[1];
        $this->webserviceAddress = $info[2];
        $this->opticianName = $info[3];
        $this->opticianAddress = $info[4];
        $this->opticianPhone = $info[5];
        $this->opticianLogo = $info[6];
        $this->showAppointmentTypes = isset($info[7]) ? $info[7] : true;
        $this->singleOpticianView = isset($info[8]) ? $info[8] : false;
        $this->singleOpticianName = isset($info[9]) ? $info[9] : '';
        
        $this->rawData = $wsdl_response_str;
        
        // $remainingValues = array_slice($info, 6);
        // $this->opticianLogo .= implode("_", $remainingValues);
    }

    // Getter methods
    public function getSite() {
        return $this->site;
    }

    public function getPassword() {
        return $this->password;
    }

    public function getWebserviceAddress() {
        return $this->webserviceAddress;
    }

    public function getOpticianName() {
        return $this->opticianName;
    }

    public function getOpticianAddress() {
        return $this->opticianAddress;
    }

    public function getOpticianPhone() {
        return $this->opticianPhone;
    }

    public function getOpticianLogo() {
        return $this->opticianLogo;
    }

    public function shouldShowAppointmentTypes(){
        return !isset($this->showAppointmentTypes) ? true : 
            (is_bool($this->showAppointmentTypes) ? $this->showAppointmentTypes :
            strtolower($this->showAppointmentTypes) =='true' );
    }

    public function getSingleOpticianView(){
        return $this->singleOpticianView;
    }

    public function getSingleOpticianName(){
        return $this->singleOpticianName;
    }

    public function jsonSerialize()
    {
        return get_object_vars($this);
    }

    public function getRawData(){
        return $this->rawData;
    }
}
?>