<?php

class AppointmentSlotDetails implements \JsonSerializable
{
    private $date;
    private $start_time;
    private $end_time;
    private $slot_str;
    private $name;

    public function __construct()
    {
    }

    public function setAllFromStr($wsdl_response_str)
    {
        $this->slot_str = $wsdl_response_str;
        // Sample string: dd/mm/yyyy hh:mm hh:mm
        // or Sample string: dd/mm/yyyy hh:mm hh:mm name name name...
        $appointment_parts = explode(" ", $wsdl_response_str);

        $this->date = $appointment_parts[0];
        $this->start_time = $appointment_parts[1];
        $this->end_time = $appointment_parts[2];
        if(count($appointment_parts) > 3){
            unset($appointment_parts[0]);
            unset($appointment_parts[1]);
            unset($appointment_parts[2]);            
            $this->name = implode(" ",$appointment_parts);
        }
    }

    public function getSlotStr(){
        return $this->slot_str;
    }

    public function getDate()
    {
        return $this->date;
    }

    public function getStartTime()
    {
        return $this->start_time;
    }

    public function getEndTime()
    {
        return $this->end_time;
    }

    public function getName(){
        return $this->name;
    }

    public function jsonSerialize() 
    {
        return get_object_vars($this);
    }
}

?>