<?php
include_once __DIR__.'/optician-panel/helpers/SessionManagementService.php';
$session_management_service = new SessionManagementService();
?>
<div class="header">
    <div class="sitecontainer">
        <div class="headerinner">
            <div class="logo">
                <img src="<?= isset($siteInfo) ? $siteInfo->getOpticianLogo() : '' ?>" alt="">
            </div>
            <div class="menu font-main">
                    <p><b><?= isset($selected_shop) ? $selected_shop->getName() : '' ?></b></p>
                    <p><?= isset($selected_shop) ? $selected_shop->getAddress() : '' ?></p>
                    <p><?= isset($selected_shop) ? $selected_shop->getPhone() : '' ?></p>
                    <?php if($session_management_service -> isLoggedIn() && strpos($_SERVER['REQUEST_URI'], 'optician-panel') !== false ): ?>
                        <div>
                            <a href="logout.php" class="logout-button">Logout</a>
                        </div>
                    <?php endif; ?>
                    <?php if($session_management_service -> isLoggedIn() && strpos($_SERVER['REQUEST_URI'], 'optician-panel') === false ): ?>
                        <div>
                            <a href="optician-panel/dashboard.php" class="logout-button">Optician Panel</a>
                        </div>
                    <?php endif; ?>
            </div>
            
        </div>
    </div>
</div>

<?php if( isset($isstepped_process) &&  $isstepped_process) : ?>
<div class="process">
    <div class="sitecontainer">
        <div class="processinner">
            <ul class="progressbar">
                <li class="font-main <?= $current_step > 1 ? 'completed' : '' ?> <?= $current_step >= 1 ? 'active' : '' ?> <?= $current_step == 1 ? 'current' : '' ?> ">
                    <?= $current_step > 1 ? 'Store Selected' : 'Select Store' ?>
                </li>
                <li class="font-main <?= $current_step > 2 ? 'completed' : '' ?> <?= $current_step >= 2 ? 'active' : '' ?> <?= $current_step == 2 ? 'current' : '' ?>">
                    <?= $current_step > 2 ? 'Appointment Slot Selected' : 'Select Appointment Slot' ?>
                </li>
                <li class="font-main <?= $current_step > 3 ? 'completed' : '' ?> <?= $current_step >= 3 ? 'active' : '' ?> <?= $current_step == 3 ? 'current' : '' ?>">
                    <?= $current_step > 3 ? 'Details Provided' : 'Provide Your Details' ?>
                </li>
                <li class="font-main <?= $current_step == 4 ? 'completed' : '' ?> <?= $current_step == 4 ? 'active' : '' ?> <?= $current_step == 4 ? 'current' : '' ?>">
                    Appointment Booking Status
                </li>
            </ul>
        </div>
    </div>
</div>
<? else: ?>
<div class="process">
    <div class="sitecontainer">
        <div class="processinner">
            <ul class="progressbar" style="text-align: center;">
                <li class="font-main">
                    Booked Appointment Details
                </li>
            </ul>
        </div>
    </div>
</div>
<? endif; ?>