<?php

class ShopInfo implements \JsonSerializable{
    private $name;
    private $address;
    private $phone;

    public function __construct($name, $address, $phone)
    {
        $this->name = $name;
        $this->address = $address;
        $this->phone = $phone;
    }

    public function getName(){
        return $this->name;
    }

    public function getAddress(){
        return $this->address;
    }

    public function getPhone(){
        return $this->phone;
    }

    public function getFullAddress(){
        return implode(" ", [$this->name, $this->address, $this->phone]);
    }

    public function jsonSerialize() : mixed
    {
        return get_object_vars($this);
    }
}

?>